unit Example1;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, MainClss, Popupbox, Buttons,
  ComCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    LHeader: TLabel;
    Image1: TImage;
    LInfo1: TLabel;
    LInfo4: TLabel;
    LExampl1: TLabel;
    GroupBox1: TGroupBox;
    LExampl6: TLabel;
    PopupBoxB: TPopupBox;
    Label11: TLabel;
    PopupBoxC: TPopupBox;
    Label12: TLabel;
    PopupBoxF: TPopupBox;
    Label15: TLabel;
    PopupBoxG: TPopupBox;
    Label16: TLabel;
    LOther: TLabel;
    LAvail1: TLabel;
    LAvail2: TLabel;
    LAvail3: TLabel;
    LAvail4: TLabel;
    LAvail7: TLabel;
    Image2: TImage;
    Image3: TImage;
    Image4: TImage;
    Image5: TImage;
    Image6: TImage;
    Image7: TImage;
    LAvail5: TLabel;
    LAvail6: TLabel;
    BitBtn1: TBitBtn;
    Label14: TLabel;
    PopupBoxE: TPopupBox;
    PopupBoxD: TPopupBox;
    Label13: TLabel;
    Bevel2: TBevel;
    BOther: TButton;
    Bevel3: TBevel;
    LExampl5: TLabel;
    PageControl1: TPageControl;
    Page4: TTabSheet;
    Page3: TTabSheet;
    Page2: TTabSheet;
    Page1: TTabSheet;
    LInfo2: TLabel;
    LInfo3: TLabel;
    RadiosOnClick: TRadioGroup;
    RadiosOnReturn: TRadioGroup;
    RadiosButton: TRadioGroup;
    BtnWidthValue: TEdit;
    UpDownBtnWidth: TUpDown;
    CheckBoxDropFocus: TCheckBox;
    CheckBoxDropArrow: TCheckBox;
    CheckBoxStyle: TCheckBox;
    PopupBoxA: TPopupBox;
    Label1: TLabel;
    Panel1: TPanel;
    LExampl2: TLabel;
    LExampl4: TLabel;
    LExampl3: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    PopupBox1: TPopupBox;
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
    procedure Edit2KeyPress(Sender: TObject; var Key: Char);
    procedure PopupBoxGDrawListItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure BitBtn1Click(Sender: TObject);
    procedure BOtherClick(Sender: TObject);
    procedure PopupBoxBPopup(Sender: TObject);
    procedure PopupBoxCPopup(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure RadiosOnClickClick(Sender: TObject);
    procedure RadiosOnReturnClick(Sender: TObject);
    procedure RadiosButtonClick(Sender: TObject);
    procedure BtnWidthValueChange(Sender: TObject);
    procedure CheckBoxDropFocusClick(Sender: TObject);
    procedure CheckBoxDropArrowClick(Sender: TObject);
    procedure CheckBoxStyleClick(Sender: TObject);
    procedure LAvail6Click(Sender: TObject);
    procedure LAvail5Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  Example2, ShellApi;

procedure TForm1.FormCreate(Sender: TObject);
begin
  // check if language is german
  if (GetUserDefaultLangID and $03FF) = 7 then begin
    Form1.Caption:= 'Vorstellung der PopupBox';
    LHeader.Caption:= 'PopupBox - Komponente  v3.15';

    Page1.Caption:= 'Was ist das?';
    Page2.Caption:= 'Beispiel';
    Page3.Caption:= 'Andere Stile';
    Page4.Caption:= 'Verfgbarkeit';

    LInfo1.Caption:= 'Die PopupBox ist eine Komponente, die ein Editierfeld mit einer '+
                     'ListBox kombiniert. Sie stellt eine Alternative zur '+
                     'ComboBox und DBComboBox in Delphi und Borland C++Builder dar.';
    LInfo2.Caption:= 'PopupBox sieht standardmssig wie eine ComboBox aus. Man kann jedoch '+
                     'Aussehen und Verhalten weitgehend ndern. So kann man z.B. festelegen:';
    LInfo3.Caption:= '- wann die Liste aufspringen soll'#10 +
                     '- was passieren soll, wenn man einen Eintrag auswhlt'#10 +
                     '- Grsse fr Editierfeld und Liste getrennt'#10 +
                     '- Ausrichtung, Farbe und Schrift fr Editierfeld und Liste'#10 +
                     '- wann bzw. ob ein Schalter angezeigt werden soll'#10 +
                     '- viele weitere Einstellungen...';
    LInfo4.Caption:= 'Das nchste Kontroll-Element auf dem Formular kann automatisch '+
                     'angewhlt werden, nachdem ein Eintrag in der PopupBox gewhlt wurde.';

    LExampl1.Caption:= 'Diese 3 Felder knnten Teil eines Eingabe-Dialogs sein:';
    LExampl5.Caption:= 'Durch Drcken der RETURN- oder TAB- Taste gelangen Sie von Feld zu Feld';
    LExampl6.Caption:= 'Im Objektinspektor kann man angeben, was passiert wenn man einen '+
                       'Listen-Eintrag mit der Maus/ENTER-Taste auswhlt.';

    LOther.Caption:= 'Darber hinaus existieren noch weitere Einstell-Mglichkeiten. '+
                     'Versuchen Sie es selbst und geben Ihrer Anwendung so einen '+
                     'persnlichen Stil!';
    BOther.Caption:= 'Beispiel 2';

    LAvail1.Caption:= 'Die kostenlose Testversion (Trial version) der PopupBox-Komponente '+
                      'besitzt die volle Functionalitt der registrierten Version. Sie luft '+
                      'aber nur, wenn auch Delphi order Borland C++Builder auf dem PC luft.';
    LAvail2.Caption:= 'Um eine selbstndig laufende Anwendung erzeugen und weitergeben zu '+
                      'knnen, mssen Sie die registrierte Version erwerben.';
    LAvail3.Caption:= 'Die Registriergebhr betrgt $24,90 ohne Quelltext '+
                      'bzw. $49,90 einschliesslich Quelltext.';
    LAvail4.Caption:= 'Wie registrieren?';
    LAvail5.Caption:= 'Wenn Sie einen CompuServe- Zugang besitzen, geht das einfach mit '+
                      'GO SWREG (ID-Nummer 6032 bzw. 6909).';
    LAvail6.Caption:= 'Sie knnen PopupBox auch online im Internet registrieren. Besuchen '+
                      'Sie unsere Homepage auf http://ourworld.compuserve.com/ '+
                      'homepages/praxisservice';
    LAvail7.Caption:= 'Ich sende Ihnen umgehend die neueste Vollversion zu!';

    BitBtn1.Caption:= 'Lies mich';
  end;
end;

procedure TForm1.Edit1KeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then begin
    Key:= #0;
    PostMessage(Handle, WM_NextDlgCtl, 0, 0);
  end;
end;

procedure TForm1.Edit2KeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then begin
    Key:= #0;
    Edit1.SetFocus;
  end;
end;

procedure TForm1.PopupBoxGDrawListItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
VAR
  Composer: String;
  TempPtr: PChar;
begin
  Composer:= PopupBoxG.Items[Index];
  TempPtr:= StrRScan(PChar(Composer), ' ');
  if TempPtr <> nil then Composer:= TempPtr+1;

  with (Control as TPopupBoxLB).Canvas do begin
    Case Index Of
      0 : begin  // Bach
        Font.Color:= clRed;
        Font.Style:= Font.Style + [fsBold];
      end;

      4 : begin  // Haendel
        Font.Color:= clNavy;
        Font.Style:= Font.Style + [fsBold];
      end;
    End;
    TextRect(Rect, Rect.Left, Rect.Top, Composer);
  end;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  ShellExecute(Handle, 'open', PChar(ExtractFilePath(Application.ExeName) +
               'readme.wri'), nil, nil, SW_SHOWDEFAULT);
end;


procedure TForm1.BOtherClick(Sender: TObject);
begin
  with TForm2.Create(Application) do try
    ShowModal;
  finally
    Free;
  end;
end;

procedure TForm1.PopupBoxBPopup(Sender: TObject);
begin
  PopupboxB.ItemIndex:= DayOfWeek(Date)-1;
end;

procedure TForm1.PopupBoxCPopup(Sender: TObject);
begin
  PopupboxC.ItemIndex:= 4;
  PopupboxC.ListBox.TopIndex:= 2;
end;

procedure TForm1.RadiosOnClickClick(Sender: TObject);
begin
  Case RadiosOnClick.ItemIndex Of
    0: PopupBox1.List.DoOnClick:= doTakeValue;
    1: PopupBox1.List.DoOnClick:= doShutUp;
    2: PopupBox1.List.DoOnClick:= doGoAway;
  End;
  PopupBox1.PopItUp;
end;

procedure TForm1.RadiosOnReturnClick(Sender: TObject);
begin
  Case RadiosOnReturn.ItemIndex Of
    0: PopupBox1.List.DoOnReturnKey:= doTakeValue;
    1: PopupBox1.List.DoOnReturnKey:= doShutUp;
    2: PopupBox1.List.DoOnReturnKey:= doGoAway;
  End;
  PopupBox1.PopItUp;
end;

procedure TForm1.RadiosButtonClick(Sender: TObject);
begin
  Case RadiosButton.ItemIndex Of
    0: PopupBox1.ShowButton:= ShowBtnNo;
    1: PopupBox1.ShowButton:= ShowBtnYes;
    2: PopupBox1.ShowButton:= ShowBtnFocus;
  End;
  BtnWidthValue.Visible:= RadiosButton.ItemIndex in [1, 2];
  UpDownBtnWidth.Visible:= RadiosButton.ItemIndex in [1, 2];
end;

procedure TForm1.BtnWidthValueChange(Sender: TObject);
begin
  PopupBox1.ShowButtonWidth:= UpDownBtnWidth.Position;
  PopupBox1.SetFocus;
end;

procedure TForm1.CheckBoxDropFocusClick(Sender: TObject);
begin
  if CheckBoxDropFocus.Checked then
    PopupBox1.DropDownOn:= PopupBox1.DropDownOn + [DropOnGetFocus]
  else
    PopupBox1.DropDownOn:= PopupBox1.DropDownOn - [DropOnGetFocus];
  PopupBox1.SetFocus;
end;

procedure TForm1.CheckBoxDropArrowClick(Sender: TObject);
begin
  if CheckBoxDropArrow.Checked then
    PopupBox1.DropDownOn:= PopupBox1.DropDownOn + [DropOnAltArrowKey]
  else
    PopupBox1.DropDownOn:= PopupBox1.DropDownOn - [DropOnAltArrowKey];
  PopupBox1.SetFocus;
end;

procedure TForm1.CheckBoxStyleClick(Sender: TObject);
begin
  if CheckBoxStyle.Checked then
    PopupBox1.Style:= pbsDropDown
  else
    PopupBox1.Style:= pbsDropDownList;
  PopupBox1.SetFocus;
end;

procedure TForm1.LAvail6Click(Sender: TObject);
begin
  ShellExecute(Application.Handle, 'open',
               'http://ourworld.compuserve.com/homepages/praxisservice/',
               nil, nil, SW_NORMAL);
end;

procedure TForm1.LAvail5Click(Sender: TObject);
begin
  ShellExecute(Application.Handle, 'open',
               'http://www.compuserve.com/cgi-bin/gocserve?CIS:SWREG',
               nil, nil, SW_NORMAL);
end;

end.
